/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  fasta header handling
  
  $File$
  $Revision: 1.2 $
  $Date: Fri, 11 Feb 2000 11:47:58 +0100 $

-----------------------------------------------------------------------------*/

#include "q_misc.h"
#include <strings.h>

#ifndef _Q_HEADERS_H
#define _Q_HEADERS_H

/* Basic quasar datastructure for sequences */
typedef struct q_headers{
  int		size;		/* number of sequences in headers */
  int		*offsets;	/* offsets[i] : offset of header i in data
				   offsets[size] : position of last char + 1 */
  char		*data;		/* data : headers */
} Q_Headers;

#define Header(headers, num)	\
		(headers->data+headers->offsets[num])
		/* returns a pointer to the first letter of header num */
#define Length(headers, num)		\
		(headers->offsets[num+1] - headers->offsets[num])
		/* returns the length of header num */

Q_Headers *NewHeaders();
/*  Creates and initializes header index */

void DeleteHeaders(Q_Headers *sset);
/*  Frees Memory allocated for headers */

Q_Headers *ReadHeaders(int sequences, char *infile);
/*  Read a headers from the file named infile.headers */

#endif  /* _Q_HEADERS_H */
