/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  neighbourhood generation module
  
  $File$
  $Revision: 1.3 $
  $Date: Wed, 29 Mar 2000 11:07:45 +0200 $

  CreateHood requires as input:
  1. length of the q-gram	q
  2. q-gram to be processed	qgram		Format: int (A=0,C=1,G=2,T=3)
  3. following q-gram		next		Format: int,-prev if last qgram
  4. an integer array allocated with NewHood
  
  CreateHood returns the number of qgrams generated. The generated qgrams are
  stored in hood. For a given qgram it generates the following:
  (Example, q=6)
  qgram: X1 X2 X3 X4 X5 X6
  next :    X2 X3 X4 X5 X6 X7

  ORIGINAL:
  hood[0]: X1 X2 X3 X4 X5 X6	
  REPLACEMENTS:
  hood[1]: RP X2 X3 X4 X5 X6  	All possible replaces of the first char (RP!=X1)
  hood[2]: X1 RP X3 X4 X5 X6    All possible replaces of the second char(RP!=X2)
    .
    .
  hood[6]: X1 X2 X3 X4 X5 RP	All possible replaces of the sixth char (RP!=X6)
  INSERTS:	(No inserts before the first, second and last character!)
  hood[7]: X1 X2 IN X3 X4 X5    All possible inserts before the third char (IN!=X3)
  hood[8]: X1 X2 X3 IN X4 X5    All possible inserts before the fourth char(IN!=X4)
  hood[9]: X1 X2 X3 X4 IN X5    All possible inserts before the fifth char (IN!=X5)
  DELETES:	(No deletion of the first/last character) 
  hood[10]:X1 X3 X4 X5 X6 X7	Deletion of the second character
  hood[11]:X1 X2 X4 X5 X6 X7    Deletion of the third character
    .
  hood[13]:X1 X2 X3 X4 X6 X7    Deletion of the fifth character
 
  NOTE 1: for deletions, a last variable keeps track of the previous delete and
        is used to prevent multiple occurences of the same qgram due to 
	repeated characters in the original qgram

  NOTE 2: if qgram is the last qgram of the query, then next should contain
	  the negative value of the second last qgram of the query. The 
	  neighbourhood generation will then handle inserts and replacements
	  as usual and deletes as follows:
  qgram:      X4 X5 X6 X7 X8 X9
  prev :   X3 X4 X5 X6 X7 X8 
  DELETES:
  hood[10]:X3 X4 X6 X7 X8 X9
  hood[11]:X3 X4 X5 X7 X8 X9
  hood[12]:X3 X4 X5 X6 X8 X9
  hood[13]:X3 X4 X5 X6 X7 X9
  hood[14]:X3 X4 X5 X6 X7 X8		IMPORTANT! IN THIS CASE THE	
					COMBINATION OF REPLACE/ORIGINAL
					WILL NOT COVER THE DELETE OF THE
					LAST CHARACTER.
	

-----------------------------------------------------------------------------*/

#ifndef _Q_HOOD_H
#define _Q_HOOD_H

#include "q_defines.h"
#include "q_misc.h"

LONG *NewHood(int q);
/* allocates the memory required for the 1-neighbourhood of a string of 
   length q */

int CreateHood(int q, LONG qgram, LONG next, LONG *hood);
/* generates the 1-neighbourhood for a string of length q that is 
   integer encoded and passed in qgram where the following (overlapping)
   qgram is given in next. If it is the last qgram in a query, this
   has to be indicated by passing next=-prev (i.e. the negative value of
   the preceeding q-gram, returns the number of q_grams generated.
*/

#endif	/* _Q_HOOD_H */
