/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  utility functions (mem allocation, file handling ...)
  
  $File$
  $Revision: 1.3 $
  $Date: Wed, 29 Mar 2000 11:07:45 +0200 $

-----------------------------------------------------------------------------*/
#ifndef _Q_MISC_H
#define _Q_MISC_H

#include <stdio.h>
#include <stdlib.h>
#include "q_defines.h"

/* provided functions */

void *MyMalloc(LONG size, char *var_name);
/*  Attempts to allocate size bytes of memory with malloc. On
    success returns pointer to allocated area, if malloc fails
    prints an errormessage including the string var_name and
    exits with OUT_OF_VIRTUAL_MEM */

void *MyRealloc(void *ptr, LONG size, char *var_name);
/*  Attempts to reallocate ptr to size bytes of memory with
    realloc. On success returns pointer to allocated area, if
    realloc fails prints an errormessage incldung the string
    var_name and exits with OUT_OF_VIRTUAL_MEM */

FILE *MyFopen(char *name, char *mode);
/*  Attempts to open the file name in the mode mode. On success
    returns the file pointer, if fopen fails prints an errormessage 
    including the file name and exits with FOPEN_FAILED. This code
    uses 64 bit file access. It requires compiler support (see makefile)
    and uses the function fopen64 */

void MyFread(void *target, LONG bytes, FILE *infile);
/*  Attempts to read bytes byte from infile to the target. It reads in blocks
    of size FILE_BLOCK. It exits with FREAD_FAILED (see q_misc.h) if less than
    bytes byte have been read */

void MyFwrite(void *source, LONG bytes, FILE *outfile);
/*  Attempts to write bytes byte from the source to outfile. Writes in blocks
    of size FILE_BLOCK. It exits with FWRITE_FAILED (see q_misc.h) if less than
    bytes byte have been written */

#endif	/* _Q_MISC_H */

