/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  fasta header handling
  
  $File$
  $Revision: 1.2 $
  $Date: Fri, 11 Feb 2000 11:47:58 +0100 $

-----------------------------------------------------------------------------*/

#include "q_headers.h"

Q_Headers *NewHeaders()
/* allocates the memory required for the 1-neighbourhood of a string of 
   length q */
{
  Q_Headers	*headers;

  headers = (Q_Headers *)MyMalloc(sizeof(Q_Headers), "header index");
  headers->size = 0;
  headers->offsets = NULL;
  headers->data = NULL;
  return(headers);
}

void DeleteHeaders(Q_Headers *headers)
/*  Frees Memory allocated for a header index */
{
  if(headers->offsets != NULL)
    free(headers->offsets);
  if(headers->data != NULL)
    free(headers->data);
  free(headers);
}


Q_Headers *ReadHeaders(int sequences, char *infile)
  /* Read all sequence headers from the .index file */
{
  Q_Headers	*headers;
  int		i, j;
  int		h_len;
  FILE		*headers_file;
  char		*filename;
   
  filename = MyMalloc(strlen(infile)+9, "headers filename");
  sprintf(filename, "%s.headers", infile);
  printf("Reading headers for %d sequences from file: %s\n", sequences, filename);
  headers_file = MyFopen(filename, "r");

  headers = NewHeaders();
  headers->size = sequences;
  headers->offsets = (int *)MyMalloc(sizeof(int) * (headers->size + 1), "header offsets");

  fseek(headers_file, 0, SEEK_END);
  h_len = ftell(headers_file);
  fseek(headers_file, 0, SEEK_SET);

  headers->data = (char *)MyMalloc(sizeof(char) * h_len, "headers");

  MyFread(headers->data, h_len * sizeof(char), headers_file);

  headers->offsets[0] = 0;
  j = 1;
  for(i=0; i<h_len; i++){
    if(headers->data[i] == '\n') {
      headers->offsets[j] = i+1;
      j++;
      if(j>sequences) 
	break;
    }
  }
  headers->offsets[sequences] = h_len + 1;

#ifdef DEBUG
  for (i=0; i<headers->size; i++) {
    printf("%20.20s\n", headers->data+headers->offsets[i]);
    getchar();
  }
#endif  

  fclose(headers_file);
  free(filename);
  return headers;
}


