/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  option handling
  
  $File$
  $Revision: 1.5 $
  $Date: Wed, 16 Feb 2000 16:16:22 +0100 $

-----------------------------------------------------------------------------*/

#include "q_options.h"

Q_Options *NewOptions()
/*  Creates and initializes an options datastructure */
{
  Q_Options	*op;
  
  op = (Q_Options *)MyMalloc(sizeof(Q_Options), "options");
  
  op->q = 0;
  op->i = 0;
  op->w = 0;
  op->t = 0;
  op->b = 0;
  op->filter_mode = 0;
  op->output_mode = 0;
  op->rquery = 0;
  op->rep_cutoff = 0;
  
  return op;
}

void DeleteOptions(Q_Options *op)
/* Frees all memory allocated for op */
{
  free(op);
}


    
void PrintOptions(Q_Options *op)
/* Prints all options set in op */       
{
  printf("q-gram length   q : %d \n",op->q);
  printf("index q-grams   i : %d \n",op->i);
  printf("window length   w : %d \n",op->w);
  printf("block threshold t : %d \n",op->t);
  printf("block size      b : %d \n",op->b);
  if(op->filter_mode == 0) 
    printf("Using exact q-gram filtration \n");
  else
    printf("Using 1-neighbourhood q-gram filtration \n");
  if(op->output_mode == 0) 
    printf("Writing Filter output to disk\n");
  if(op->output_mode == 1)
    printf("Using formatdb and blastall to scan filter output\n");
  if(op->output_mode == 2)
    printf("Using CreateBlastDB and blastall to scan filter output\n");
  if(op->output_mode == 3)
    printf("Using CreateBlastDB and CallBlast to scan filter output\n");
  if(op->rquery == 0)
    printf("Looking for query sequences only (no reverse complements) \n");
  else
    printf("Searching for queries and their reverse complements\n");
  if(op->rep_cutoff > 0)
    printf("Procecssing q-grams repeated less than %d times\n",op->rep_cutoff);
  else {
    printf("Processing all q-gram hit lists\n");
    op->rep_cutoff = (1 << 30);	  /* CHANGE!!! BETTER TO SET THIS TO DB_SIZE */
  }
}

Q_Options *ReadOptions(char *infile)
/*  Read all user options from the file named infile */
{
  FILE		*op_file;
  Q_Options	*op;
  
  printf("Reading options from file: %s \n", infile);
  op_file = MyFopen(infile, "r");

  op = NewOptions();

  if(fscanf(op_file, "%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d", &op->q, &op->i, 
	&op->w, &op->t, &op->b, &op->filter_mode, &op->output_mode, 
	&op->rquery, &op->rep_cutoff) != NUM_OPTIONS) {
    printf("Corrupt options file, please specify the following options \n");
    printf("q-gram length q (>0)\n");
    printf("index q-gram length i (0 ... 15)\n");
    printf("window length w (>q)\n");
    printf("block threshold (1 ... w-q+1)\n");
    printf("block size (power of 2, > w)\n");
    printf("search mode (0 = exact q-gram filter, or 1 = 1-neighbourhood filter)\n");
    printf("output mode (0 = filter output, 1 = Call formatdb and blastall, 2 = own formatdb ,call blastall, 3 = ramblast)\n");
    printf("reverse complement queries off/on (0 = off / 1 = on)\n");
    printf("repeat cutoff (0 consider all hits, >0 consider only q-grams less frequent than the cutoff\n");
    printf("All options have to be integer and saved in ascci format followed by a newline\n");
    exit(Q_OPTIONS_CORRUPT_FILE);
  }
  fclose(op_file);
  PrintOptions(op);

  return op;
}
