/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  main program
  
  $File$
  $Revision: 1.8 $
  $Date: Wed, 29 Mar 2000 11:07:45 +0200 $

call syntax :
quasar	optionsfile query_sset db_sset

error codes : not consistent yet

-----------------------------------------------------------------------------*/

#include "quasar.h"

/* MAIN PROGRAM  */
int main (int argc, char *argv[])
{
  /* MAIN DATASTRUCTURES */
  Q_Options	*op;
  Q_SSet	*queries;
  Q_SSet	*db;
  Q_Headers	*qheaders;
  Q_Headers	*headers;
  Q_Index	*index;
  Q_Blocks	*blocks;
  
  int		i;
  char		*rquery_seq;
  LONG	 	*query;
  LONG	    	*rquery;
  int		*fb;
  
  struct timeval	tp;
  long		ts[10];

  gettimeofday(&tp, NULL);
  ts[0] = tp.tv_sec;

  /* SCAN ARGUMENTS  */
  ParseArguments(argc);
  
  if(sizeof(LONG) != 8)
    printf("ERROR: please set LONG in defines.h to a 64bit integer\n");

  /* READ REQUIRED DATA FROM DISK */
  op = ReadOptions(argv[1]);
  queries = ReadSSet(argv[2]);
  db = ReadSSet(argv[3]);
  qheaders = ReadHeaders(queries->size, argv[2]);
  headers = ReadHeaders(db->size, argv[3]);
  index = ReadIndex(argv[3], op->i);

  /* INITIALIZE BLOCK ARRAY */
  blocks = InitBlocks(db->offsets[db->size], op->b, op->t);

  /* SEARCH DATABASE FOR ALL QUERIES IN queries */

  gettimeofday(&tp, NULL);
  printf("Done initializing in %ld seconds\n", tp.tv_sec - ts[0]);
  ts[0] = 0;
  ts[1] = 0;
  ts[2] = 0;
  ts[3] = 0;
  ts[8] = tp.tv_sec;
  ts[9] = tp.tv_usec;

  for(i=0; i<queries->size; i++) {
    printf("--------------------------------------------------------\n");
    printf("Processing query %d: %d - %d\n",i, Start(queries,i), End(queries,i));
#ifndef DEBUG
    printf("query sequence: %30.30s...\n", Header(qheaders, i));
#endif

    /* RESET BLOCK ARRAY */
    ClearBlocks(blocks);

    /* GET ARRAY OF TUPLES FOR CURRENT QUERY */
    query = GetSSetQgrams(queries, i, op);

    /* FILL BLOCKS WITH CURRENT QUERY USING WINDOW LENGTH W */
    AddSequence(db, Sequence(queries, i), blocks, index, query, op); 

    /* DO THE SAME FOR THE REVERSE COMPLEMENT OF THE QUERY */
    if(op->rquery == 1) {
      /* RESET ALL BLOCKS WITH COUNTER < T TO 0 */
      ResetBlocks(blocks);
      rquery_seq = GetReverseSSetSequence(queries, i);
      rquery = GetReverseSSetQgrams(queries, i, op); 
      AddSequence(db, rquery_seq, blocks, index, rquery, op);
    }

    PrintBlocksStatistics(blocks);

    fb = GetFullBlocks(blocks);			         /* FIND FULL BLOCKS */

    FindSSetEntries(db, fb);		       /* FIND INTERESTING SEQUENCES */

    gettimeofday(&tp, NULL);   
    ts[0] += tp.tv_sec - ts[8];
    ts[1] += tp.tv_usec - ts[9];
    ts[8] = tp.tv_sec;
    ts[9] = tp.tv_usec;

    /* WORK ON THE INTERESTING SEQUENCES CONTAINED IN THE FULL BLOCKS */
    
    printf("Processing Hits\n");

    ProcessHits(headers, queries, i, db, fb, op->output_mode);

    free(fb);					 /* FREE LIST OF FULL BLOCKS */
    free(query);				   /* FREE QUERY TUPLE ARRAY */
    if(op->rquery == 1){
      free(rquery_seq);
      free(rquery);
    }
    gettimeofday(&tp, NULL);   
    ts[2] += tp.tv_sec - ts[8];
    ts[3] += tp.tv_usec - ts[9];
    ts[8] = tp.tv_sec;
    ts[9] = tp.tv_usec;
    if(ts[1] < 0) {
      ts[0]--;
      ts[1] += 1000000;
    }
    if(ts[3] < 0) {
      ts[2]--;
      ts[3] += 1000000;
    }

  }

  while(ts[1]>999999){
    ts[0]++;
    ts[1] -= 1000000;
  }
  while(ts[3]>999999){
    ts[2]++;
    ts[3] -= 1000000;
  }
  printf("--------------------------------------------------------\n");
  printf("Running times (excluding DB read):\n");
  printf("Total time used for filter step: %ld seconds, %ld milliseconds\n",
	  ts[0], ts[1]/1000);
  printf("Time per search: %f milliseconds \n", 
	  ((float)(ts[0] * 1000000 + ts[1])/(float)queries->size)/1000);
  printf("Total time used for scan step: %ld seconds, %ld milliseconds\n",
	  ts[2], ts[3]/1000);
  printf("Time per search: %f milliseconds\n", 
	  ((float)(ts[2] * 1000000 + ts[3])/(float)queries->size)/1000);
  if(ts[1] + ts[3]> 1000000) {
    ts[0]++;
    ts[1] -= 1000000;
  }
    
  printf("Total elapsed time: %ld sec %ld milliseconds \n", 
	  ts[0]+ts[2], (ts[1]+ts[3])/1000);
  printf("Time per search: %f milliseconds\n", 
	  ((float)((ts[0]+ts[2]) * 1000000 + ts[1] + ts[3])/(float)queries->size)/1000);
  /* CLEAN UP        */
  DeleteSSet(db);
  DeleteSSet(queries);
  DeleteIndex(index);
  DeleteOptions(op);
  DeleteBlocks(blocks);
  DeleteHeaders(headers);
  DeleteHeaders(qheaders);
  return 1;
}
